package com.ximai.mes.od.service;

import com.ximai.mes.od.domain.OdSalesOrder;

import java.util.List;

/**
 * 销售订单Service接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface IOdSalesOrderService {
    /**
     * 查询销售订单
     *
     * @param id 销售订单主键
     * @return 销售订单
     */
    OdSalesOrder selectOdSalesOrderById(Long id);

    /**
     * 查询销售订单列表
     *
     * @param odSalesOrder 销售订单
     * @return 销售订单集合
     */
    List<OdSalesOrder> selectOdSalesOrderList(OdSalesOrder odSalesOrder);

    /**
     * 新增销售订单
     *
     * @param odSalesOrder 销售订单
     * @return 结果
     */
    int insertOdSalesOrder(OdSalesOrder odSalesOrder);

    /**
     * 修改销售订单
     *
     * @param odSalesOrder 销售订单
     * @return 结果
     */
    int updateOdSalesOrder(OdSalesOrder odSalesOrder);

    /**
     * 批量删除销售订单
     *
     * @param ids 需要删除的销售订单主键集合
     * @return 结果
     */
    int deleteOdSalesOrderByIds(String[] ids);

    /**
     * 删除销售订单信息
     *
     * @param id 销售订单主键
     * @return 结果
     */
    int deleteOdSalesOrderById(String id);
}
