package com.ximai.mes.od.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 客户采购订单对象 od_purchase_order
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Data
public class OdPurchaseOrder extends BaseEntity {
    private static final long serialVersionUID = 1L;

    private Long id;

    /**
     * 订单编号
     */
    @Excel(name = "订单编号")
    private String orderNo;

    /**
     * 客户ID
     */
    @Excel(name = "客户ID")
    private Long clientId;

    private String clientNo;

    private String clientName;

    /**
     * 交货日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "交货日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date deliveryDate;

    /**
     * 状态
     */
    @Excel(name = "状态")
    private String state;

    /**
     * 来源文件
     */
    @Excel(name = "来源文件")
    private String source;

    private List<OdPurchaseOrderDetail> detailList;

}
