package com.ximai.mes.md.vo;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import java.math.BigDecimal;

/**
 * 销售单位转换对象 md_sale_unit
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public class MdSaleUnitVo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** ID */
    private Long id;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 销售单位 */
    @Excel(name = "销售单位")
    private String unitId;

    /** 销售换算值 */
    @Excel(name = "销售换算值")
    private BigDecimal saleConversionValue;

    private String unitCode;

    private String unitName;

    public String getUnitCode() {
        return unitCode;
    }

    public void setUnitCode(String unitCode) {
        this.unitCode = unitCode;
    }

    public String getUnitName() {
        return unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setUnitId(String unitId)
    {
        this.unitId = unitId;
    }

    public String getUnitId()
    {
        return unitId;
    }
    public void setSaleConversionValue(BigDecimal saleConversionValue)
    {
        this.saleConversionValue = saleConversionValue;
    }

    public BigDecimal getSaleConversionValue()
    {
        return saleConversionValue;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("itemId", getItemId())
            .append("unitId", getUnitId())
            .append("saleConversionValue", getSaleConversionValue())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
