package com.ximai.mes.md.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.cal.mapper.CalPlanWorkunitMapper;
import com.ximai.mes.constant.TaskStatusEnum;
import com.ximai.mes.constant.TaskWorkunitStatusEnum;
import com.ximai.mes.md.domain.MdWorkstation;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.domain.MdWorkunitWorker;
import com.ximai.mes.md.mapper.MdWorkstationMapper;
import com.ximai.mes.md.mapper.MdWorkunitMapper;
import com.ximai.mes.md.mapper.MdWorkunitWorkerMapper;
import com.ximai.mes.md.service.IMdWorkunitService;
import com.ximai.mes.md.vo.MdWorkunitVo;
import com.ximai.mes.pro.domain.task.ProTask;
import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.mapper.task.ProTaskMapper;
import com.ximai.mes.pro.mapper.task.ProTaskWorkunitMapper;
import com.ximai.mes.pro.service.task.IProTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * 工作单元Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Service
public class MdWorkunitServiceImpl implements IMdWorkunitService {
    @Resource
    ProTaskMapper proTaskMapper;
    @Resource
    private MdWorkunitMapper mdWorkunitMapper;
    @Resource
    private ProTaskWorkunitMapper proTaskWorkunitMapper;
    @Autowired
    private IProTaskService proTaskService;
    @Resource
    private MdWorkstationMapper mdWorkstationMapper;
    @Autowired
    private CalPlanWorkunitMapper calPlanWorkunitMapper;
    @Autowired
    private MdWorkunitWorkerMapper mdWorkunitWorkerMapper;
    /**
     * 查询工作单元
     *
     * @param workunitId 工作单元主键
     * @return 工作单元
     */
    @Override
    public MdWorkunitVo selectMdWorkunitByWorkunitId(Long workunitId) {
        return mdWorkunitMapper.selectMdWorkunitByWorkunitId(workunitId);
    }

    /**
     * 查询工作单元列表
     *
     * @param mdWorkunit 工作单元
     * @return 工作单元
     */
    @Override
    public List<MdWorkunitVo> selectMdWorkunitList(MdWorkunit mdWorkunit) {
        return mdWorkunitMapper.selectMdWorkunitLists(mdWorkunit);
    }

    @Override
    public List<MdWorkunitVo> selectMdWorkunitListByUser(QueryWrapper<MdWorkunit> query) {
        return mdWorkunitMapper.selectMdWorkunitListByUser(query);
    }

    @Override
    public List<MdWorkunitVo> selectMdWorkstationListByUser(String userName) {
        return mdWorkunitMapper.selectMdWorkstationListByUser(new QueryWrapper<MdWorkunitVo>().eq("user_name", userName));
    }

    /**
     * 新增工作单元
     *
     * @param mdWorkunit 工作单元
     * @return 结果
     */
    @Override
    public int insertMdWorkunit(MdWorkunit mdWorkunit) {
        mdWorkunit.createAction();
        if(mdWorkunit.getWorkstationId() != null){
            MdWorkstation mdWorkstation = mdWorkstationMapper.selectMdWorkstationByWorkstationId(mdWorkunit.getWorkstationId());
            if(mdWorkstation != null)
                mdWorkunit.setWorkstationCode(mdWorkstation.getWorkstationCode());
        }else{
            MdWorkunit mdWorkunitCheck = mdWorkunitMapper.selectMdWorkunitByWorkunitCodes(mdWorkunit.getWorkunitCode());
            ExceptionUtil.checkTrueThrowException(mdWorkunitCheck != null, MessageUtils.message("md.workUnit.error.workunitCode.unique"));
        }
        return mdWorkunitMapper.insertMdWorkunit(mdWorkunit);
    }

    /**
     * 新增工作单元
     *
     * @param mdWorkunit 工作单元
     * @return 结果
     */
    @Override
    public int insertMdWorkunit2(MdWorkunit mdWorkunit) {
//        mdWorkunit.createAction();
        mdWorkunit.setCreateTime(DateUtils.getNowDate());
        return mdWorkunitMapper.insertMdWorkunit(mdWorkunit);
    }


    /**
     * 修改工作单元
     *
     * @param mdWorkunit 工作单元
     * @return 结果
     */
    @Override
    public int updateMdWorkunit(MdWorkunit mdWorkunit) {
        mdWorkunit.updateAction();
        return mdWorkunitMapper.updateMdWorkunit(mdWorkunit);
    }

    @Override
    public int updateMdWorkunits(MdWorkunit mdWorkunit) {
        mdWorkunit.setUpdateTime(DateUtils.getNowDate());
        return mdWorkunitMapper.updateMdWorkunit(mdWorkunit);
    }

    /**
     * 批量删除工作单元
     *
     * @param workunitIds 需要删除的工作单元主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkunitByWorkunitIds(Long[] workunitIds) {
        deleteCheck(workunitIds);
        return mdWorkunitMapper.deleteMdWorkunitByWorkunitIds(workunitIds);
    }

    /**
     * 删除工作单元信息
     *
     * @param workunitId 工作单元主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkunitByWorkunitId(Long workunitId) {
        Long[] longs = new Long[1];
        longs[0] = workunitId;
        deleteCheck(longs);
        return mdWorkunitMapper.deleteMdWorkunitByWorkunitId(workunitId);
    }

    public void deleteCheck(Long[] workunitIds){
        for (Long  workunitId : workunitIds){
            ProTaskWorkunit proTaskWorkunit = new ProTaskWorkunit();
            proTaskWorkunit.setWorkunitId(workunitId);
            List<ProTaskWorkunit> proTaskWorkunits = proTaskWorkunitMapper.selectProTaskWorkunitList(proTaskWorkunit);
            if (proTaskWorkunits.size() != 0) {
                ExceptionUtil.checkTrueThrowException(true, MessageUtils.message("md.workUnit.error.can.not.remove"));
            }
            CalPlanWorkunit calPlanWorkunit = new CalPlanWorkunit();
            calPlanWorkunit.setWorkunitId(workunitId);
            List<CalPlanWorkunit> calPlanWorkunits = calPlanWorkunitMapper.selectCalPlanWorkunitList(calPlanWorkunit);
            if (calPlanWorkunits.size() != 0) {
                ExceptionUtil.checkTrueThrowException(true, MessageUtils.message("md.workUnit.error.can.not.remove"));
            }
            MdWorkunitWorker mdWorkunitWorker = new MdWorkunitWorker();
            mdWorkunitWorker.setWorkunitId(workunitId);
            List<MdWorkunitWorker> mdWorkunitWorkers = mdWorkunitWorkerMapper.selectMdWorkunitWorkerList(mdWorkunitWorker);
            if (mdWorkunitWorkers.size() != 0) {
                ExceptionUtil.checkTrueThrowException(true, MessageUtils.message("md.workUnit.error.can.not.remove"));
            }
        }
    }

    @Override
    @Transactional
    public int workunitCreate(MdWorkunitVo mdWorkunitVo) {

        // TODO EP 传MES接口
        char updateLog = mdWorkunitVo.getUpdateLog();
        MdWorkunit mdWorkunit = new MdWorkunit();
        BeanUtil.copyProperties(mdWorkunitVo, mdWorkunit);
        //新增
        int i;
        if (updateLog == 'I') {
            MdWorkunit mdWorkunit1 = mdWorkunitMapper.selectMdWorkunitByWorkunitCodes(mdWorkunit.getWorkunitCode());
            ExceptionUtil.checkTrueThrowException(Objects.nonNull(mdWorkunit1), MessageUtils.message("basic.error.data.exist"));
            //判断工作中心是否为空
            if (StringUtils.isNotEmpty(mdWorkunit.getWorkunitCode())) {
                MdWorkstation mdWorkstation = mdWorkstationMapper.selectMdWorkstationByWorkstationCodes(mdWorkunit.getWorkstationCode());
                if (Objects.isNull(mdWorkstation)) {
                    return 4;
                }
                mdWorkunit.setWorkstationId(mdWorkstation.getWorkstationId());
            }
            mdWorkunit.setFaultFlag("N");
            mdWorkunit.setCreateBy("EP");
            i = insertMdWorkunit2(mdWorkunit);
        } else if (updateLog == 'D') {
            MdWorkunit mdWorkunit1 = mdWorkunitMapper.selectMdWorkunitByWorkunitCodes(mdWorkunit.getWorkunitCode());
            ExceptionUtil.checkTrueThrowException(Objects.isNull(mdWorkunit1), MessageUtils.message("basic.data.not.exist"));
            ExceptionUtil.checkTrueThrowException(mdWorkunit1.getEnableFlag().equals("N"), MessageUtils.message("basic.data.disable"));
            ProTaskWorkunit proTaskWorkunit = new ProTaskWorkunit();
            proTaskWorkunit.setWorkunitId(mdWorkunit1.getWorkunitId());
            List<ProTaskWorkunit> proTaskWorkunits = proTaskWorkunitMapper.selectProTaskWorkunitList(proTaskWorkunit);
            if (proTaskWorkunits.size() != 0) {
                ExceptionUtil.checkTrueThrowException(true, MessageUtils.message("md.workUnit.error.can.not.remove"));
            }
            mdWorkunit.setFaultFlag(mdWorkunit1.getFaultFlag());
            mdWorkunit.setWorkstationId(mdWorkunit1.getWorkstationId());
            mdWorkunit.setWorkunitId(mdWorkunit1.getWorkunitId());
            mdWorkunitMapper.updateMdWorkunit(mdWorkunit);
            return 3;
        } else {
            MdWorkunit mdWorkunit1 = mdWorkunitMapper.selectMdWorkunitByWorkunitCodes(mdWorkunit.getWorkunitCode());
            ExceptionUtil.checkTrueThrowException(Objects.isNull(mdWorkunit1), MessageUtils.message("basic.error.data.not.exist"));
            //判断工作中心是否为空
            if (StringUtils.isNotEmpty(mdWorkunit.getWorkunitCode())) {
                MdWorkstation mdWorkstation = mdWorkstationMapper.selectMdWorkstationByWorkstationCodes(mdWorkunit.getWorkstationCode());
                if (Objects.isNull(mdWorkstation)) {
                    return 4;
                }
                mdWorkunit.setWorkstationId(mdWorkstation.getWorkstationId());
            }
            mdWorkunit.setFaultFlag(mdWorkunit1.getFaultFlag());
            mdWorkunit.setWorkunitId(mdWorkunit1.getWorkunitId());
            mdWorkunit.setUpdateBy("EP");
            mdWorkunit.setFaultFlag(mdWorkunit1.getFaultFlag());
            updateMdWorkunits(mdWorkunit);
            return 2;
        }
        return i;
    }

    @Override
    public List<MdWorkunitVo> selectMdWorkunitJoinWorkstation(QueryWrapper<MdWorkunitVo> query) {
        return mdWorkunitMapper.selectMdWorkunitJoinWorkstation(query);
    }

    @Override
    public List<MdWorkunit> selectListByQw(QueryWrapper<MdWorkunit> query) {
        return mdWorkunitMapper.selectListByQw(query);
    }

}
