package com.ximai.mes.md.service.impl;

import com.ximai.mes.md.domain.MdFaceColor;
import com.ximai.mes.md.mapper.MdFaceColorMapper;
import com.ximai.mes.md.service.MdFaceColorService;
import com.ximai.mes.md.vo.MdFaceColorVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
* @author 16508
* @description 针对表【md_face_color(产品版面颜色)】的数据库操作Service实现
* @createDate 2024-01-15 19:08:20
*/
@Service
public class MdFaceColorServiceImpl implements MdFaceColorService{

    @Autowired
    private MdFaceColorMapper mdFaceColorMapper;

    @Override
    public MdFaceColorVo selectMdFaceColorByFaceColorId(Long faceColor) {
        return mdFaceColorMapper.selectMdFaceColorByMdFaceColorId(faceColor);
    }

    @Override
    public List<MdFaceColorVo> selectMdFaceColorList(MdFaceColor faceColor) {
        return mdFaceColorMapper.selectMdFaceColorList(faceColor);
    }

    @Override
    public int insertMdFaceColor(MdFaceColor mdFaceColor) {
        return mdFaceColorMapper.insertMdFaceColor(mdFaceColor);
    }

    @Override
    public int updateMdFaceColor(MdFaceColor mdFaceColor) {
        return mdFaceColorMapper.updateMdFaceColor(mdFaceColor);
    }

    @Override
    public int deleteMdFaceColorByFaceColorIds(Long[] faceColorIds) {
        return mdFaceColorMapper.deleteMdFaceColorByMdFaceColorIds(faceColorIds);
    }

    @Override
    public String checkMdFaceColorUnique(MdFaceColor mdFaceColor) {
        return mdFaceColorMapper.checkMdFaceColorUnique(mdFaceColor);
    }
}




