package com.ximai.mes.md.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.ximai.common.exception.ServiceException;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.bean.BeanValidators;
import lombok.AllArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdClientItemMapper;
import com.ximai.mes.md.domain.MdClientItem;
import com.ximai.mes.md.service.IMdClientItemService;

import javax.validation.Validator;


/**
 * 客户产品对照Service业务层处理
 *
 * @author generator
 * @date 2024-01-25
 */
@Service
@AllArgsConstructor
public class MdClientItemServiceImpl extends ServiceImpl<MdClientItemMapper, MdClientItem> implements IMdClientItemService {

    @Autowired
    private Validator validator;
    @Autowired
    private MdClientItemMapper mdClientItemMapper;


    @Override
    public IPage<MdClientItem> page(Map<String, Object> params) {
        final Integer pageNum = MapUtil.getInt(params, "pageNum");
        final Integer pageSize = MapUtil.getInt(params, "pageSize");
        return baseMapper.pageBy(new Page<>(pageNum, pageSize), params);
    }

    /**
     * 查询客户产品对照
     *
     * @param id 客户产品对照主键
     * @return 客户产品对照
     */
    @Override
    public MdClientItem selectById(String id) {
        return baseMapper.getById(id);
    }

    @Override
    public List<MdClientItem> selectList(MdClientItem mdClientItem) {
        QueryWrapper<MdClientItem> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("client_code", mdClientItem.getClientCode());
        return list(queryWrapper);
    }

    /**
     * 新增客户产品对照
     *
     * @param mdClientItem 客户产品对照
     * @return 结果
     */
    @Override
    public Boolean insert(MdClientItem mdClientItem) {
        mdClientItem.setCreateTime(DateUtils.getNowDate());
        return save(mdClientItem);
    }

    /**
     * 修改客户产品对照
     *
     * @param mdClientItem 客户产品对照
     * @return 结果
     */
    @Override
    public Boolean update(MdClientItem mdClientItem) {
        mdClientItem.setUpdateTime(DateUtils.getNowDate());
        return updateById(mdClientItem);
    }

    /**
     * 批量删除客户产品对照
     *
     * @param ids 需要删除的客户产品对照主键
     * @return 结果
     */
    @Override
    public Boolean deleteByIds(List<String> ids) {
        return removeByIds(ids);
    }

    /**
     * 删除客户产品对照信息
     *
     * @param id 客户产品对照主键
     * @return 结果
     */
    @Override
    public Boolean deleteById(String id) {
        return removeById(id);
    }

    /**
     * 导入产品对照组
     *
     * @param mdClientItemsList
     * @param updateSupport
     * @param operaName
     * @return Msg
     */
    @Override
    public void importMdClientItem(List<MdClientItem> mdClientItemsList, String clientCode, boolean updateSupport, String operaName) {
        if (CollectionUtil.isEmpty(mdClientItemsList)) {
            throw new ServiceException(MessageUtils.message("basic.import.error.not.null"));
        }

    }

}
