package com.ximai.mes.md.service.impl;

import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdBrand;
import com.ximai.mes.md.mapper.MdBrandMapper;
import com.ximai.mes.md.service.IMdBrandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2024/1/16
 * description:
 */
@Service
public class MdBrandServiceImpl implements IMdBrandService {

    @Autowired
    private MdBrandMapper mdBrandMapper;

    @Override
    public List<MdBrand> selectMdBrandList(MdBrand mdBrand) {
        return mdBrandMapper.selectMdBrandList(mdBrand);
    }

    @Override
    public MdBrand selectMdBrandByBrandId(Long brandId) {
        return mdBrandMapper.selectMdBrandByBrandId(brandId);
    }

    @Override
    public String checkCodeUnique(MdBrand mdBrand) {
        MdBrand brand = mdBrandMapper.checkCodeUnique(mdBrand);
        Long brandId = mdBrand.getBrandId() == null ? -1L : mdBrand.getBrandId();
        if (StringUtils.isNotNull(brand) && brand.getBrandId().longValue() != brandId) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkNameUnique(MdBrand mdBrand) {
        MdBrand brand = mdBrandMapper.checkNameUnique(mdBrand);
        Long brandId = mdBrand.getBrandId()==null?-1L:mdBrand.getBrandId();
        if(StringUtils.isNotNull(brand) && brand.getBrandId().longValue() != brandId){
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public int insertMdBrand(MdBrand mdBrand) {
        mdBrand.setCreateTime(DateUtils.getNowDate());
        return mdBrandMapper.insertMdBrand(mdBrand);
    }

    @Override
    public int updateMdBrand(MdBrand mdBrand) {
        mdBrand.setUpdateTime(DateUtils.getNowDate());
        return mdBrandMapper.updateMdBrand(mdBrand);
    }

    @Override
    public int deleteMdBrandByBrandId(Long brandId) {
        return mdBrandMapper.deleteMdBrandByBrandId(brandId);
    }

//    @Override
//    public int deleteMdBrandByBrandIds(Long[] brandIds) {
//        return 0;
//    }
}
