package com.ximai.mes.md.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.core.domain.TreeSelect;
import com.ximai.common.core.domain.entity.MdItemType;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdVendor;
import com.ximai.mes.md.mapper.ItemTypeMapper;
import com.ximai.mes.md.service.IItemTypeService;
import com.ximai.mes.md.vo.MdItemTypeVo;
import com.ximai.mes.remote.ErpService;
import com.ximai.mes.remote.dto.MdItemTypeErpDto;
import com.ximai.mes.remote.dto.MdItemTypeErpQuery;
import com.ximai.mes.remote.dto.MdVendorErpDto;
import com.ximai.mes.remote.dto.MdVendorErpQuery;
import com.ximai.system.strategy.AutoCodeUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class ItemTypeServiceImpl implements IItemTypeService {

    @Autowired
    private ItemTypeMapper itemTypeMapper;

    @Autowired
    private AutoCodeUtil autoCodeUtil;
    @Autowired
    private ErpService erpService;

    @Override
    public List<MdItemType> selectItemTypeList(MdItemType mdItemType) {
        return itemTypeMapper.selectItemTypeList(mdItemType);
    }

    @Override
    public MdItemType selectItemTypeById(Long itemTypeId) {
        return itemTypeMapper.selectItemTypeById(itemTypeId);
    }

    @Override
    public MdItemType selectItemTypeByItemTypeName(String itemTypeName) {
        return itemTypeMapper.selectItemTypeByItemTypeName(itemTypeName);
    }

    @Override
    public List<TreeSelect> buildTreeSelect(List<MdItemType> list) {
        List<MdItemType> mdItemTypes = buildTree(list);
        return mdItemTypes.stream().map(TreeSelect::new).collect(Collectors.toList());
    }

    private List<MdItemType> buildTree(List<MdItemType> mdItemTypes) {
        List<MdItemType> returnList = new ArrayList<MdItemType>();
        List<Long> tempList = new ArrayList<Long>();
        for (MdItemType it : mdItemTypes) {
            tempList.add(it.getItemTypeId());
        }

        for (MdItemType it : mdItemTypes) {
            if (!tempList.contains(it.getParentTypeId())) {
                recursionFn(mdItemTypes, it);
                returnList.add(it);
            }
        }
        if (returnList.isEmpty()) {
            returnList = mdItemTypes;
        }
        return returnList;
    }

    /**
     * 递归列表
     */
    private void recursionFn(List<MdItemType> list, MdItemType t) {
        // 得到子节点列表
        List<MdItemType> childList = getChildList(list, t);
        t.setChildren(childList);
        for (MdItemType tChild : childList) {
            if (hasChild(list, tChild)) {
                recursionFn(list, tChild);
            }
        }
    }

    /**
     * 得到子节点列表
     */
    private List<MdItemType> getChildList(List<MdItemType> list, MdItemType t) {
        List<MdItemType> tlist = new ArrayList<MdItemType>();
        for (MdItemType n : list) {
            if (StringUtils.isNotNull(n.getParentTypeId()) && n.getParentTypeId().longValue() == t.getItemTypeId().longValue()) {
                tlist.add(n);
            }
        }
        return tlist;
    }

    /**
     * 判断是否有子节点
     */
    private boolean hasChild(List<MdItemType> list, MdItemType t) {
        return getChildList(list, t).size() > 0;
    }


    @Override
    public String checkItemTypeCodeUnique(MdItemType mdItemType) {
        MdItemType mdItemType1 = itemTypeMapper.checkItemTypeCodeUnique(mdItemType.getItemTypeCode(), mdItemType.getParentTypeId());
        Long itemTypeId = mdItemType.getItemTypeId() == null ? -1L : mdItemType.getItemTypeId();
        if (StringUtils.isNotNull(mdItemType1) && itemTypeId.longValue() != mdItemType1.getItemTypeId().longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkItemTypeNameUnique(MdItemType mdItemType) {
        MdItemType mdItemType1 = itemTypeMapper.checkItemTypeNameUnique(mdItemType.getItemTypeName(), mdItemType.getParentTypeId());
        Long itemTypeId = mdItemType.getItemTypeId() == null ? -1L : mdItemType.getItemTypeId();
        if (StringUtils.isNotNull(mdItemType1) && itemTypeId.longValue() != mdItemType1.getItemTypeId().longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public Integer insertItemType(MdItemType mdItemType) {
        if (mdItemType.getParentTypeId() != null) {
            MdItemType parent = itemTypeMapper.selectItemTypeById(mdItemType.getParentTypeId());
            if (StringUtils.isNotNull(parent)) {
                mdItemType.setAncestors(parent.getAncestors() + "," + parent.getItemTypeId());
            }
        }
        return itemTypeMapper.insertItemType(mdItemType);
    }

    @Override
    public Integer updateItemType(MdItemType mdItemType) {
        return itemTypeMapper.updateItemType(mdItemType);
    }

    @Override
    public Integer removeItemType(Long itemTypeId) {
        return itemTypeMapper.deleteItemTypeById(itemTypeId);
    }

    @Override
    public boolean checkHasChild(Long itemTypeId) {
        int num = itemTypeMapper.hasChildByItemTypeId(itemTypeId);
        return num > 0 ? true : false;
    }

    @Override
    public boolean checkHasItem(Long itemTypeId) {
        int num = itemTypeMapper.hasItemByItemTypeId(itemTypeId);
        return num > 0 ? true : false;
    }


    @Override
    public void synchroItemType() {
        MdItemTypeErpQuery itemTypeErpQuery = new MdItemTypeErpQuery();
        itemTypeErpQuery.setCurrent(1);
        itemTypeErpQuery.setPageSize(1000);//每次抓取1000行
        List<MdItemTypeErpDto> list = erpService.getInvmaList(itemTypeErpQuery).getData();
        list.forEach(s->{
            MdItemType itemType = new MdItemType();
            itemType.setItemTypeCode(s.getItemTypeCode());
            List<MdItemType> dbList = this.selectItemTypeList(itemType);
            if(dbList.size()==0){
                MdItemType insertTemp = BeanUtil.toBeanIgnoreError(s, MdItemType.class);
                insertTemp.setItemTypeId(Long.valueOf(insertTemp.getItemTypeCode()));
                insertTemp.setAncestors("0");
                this.insertItemType(insertTemp);
            }else{
                BeanUtil.copyProperties(s, dbList.get(0));
                this.updateItemType(dbList.get(0));
            }
        });
    }
}
