package com.ximai.mes.md.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ximai.mes.md.domain.MdSapDictData;

import java.util.List;
import java.util.Map;

/**
 * sap特性字典数据Service接口
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public interface IMdSapDictDataService {
    /**
     * 查询sap特性字典数据
     *
     * @param id sap特性字典数据主键
     * @return sap特性字典数据
     */
    MdSapDictData selectById(String id);

    /**
     * 查询sap特性字典数据列表
     *
     * @param mdSapDictData sap特性字典数据
     * @return sap特性字典数据集合
     */
    List<MdSapDictData> selectList(MdSapDictData mdSapDictData);

    IPage<MdSapDictData> pageByMap(Map<String, Object> params);

    /**
     * 新增sap特性字典数据
     *
     * @param mdSapDictData sap特性字典数据
     * @return 结果
     */
    int insert(MdSapDictData mdSapDictData);

    /**
     * 修改sap特性字典数据
     *
     * @param mdSapDictData sap特性字典数据
     * @return 结果
     */
    int update(MdSapDictData mdSapDictData);

    /**
     * 批量删除sap特性字典数据
     *
     * @param ids 需要删除的sap特性字典数据主键集合
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /**
     * 删除sap特性字典数据信息
     *
     * @param id sap特性字典数据主键
     * @return 结果
     */
    int deleteById(String id);
}
