package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdSaleOrderType;

/**
 * 销售订单类型Service接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface IMdSaleOrderTypeService
{
    /**
     * 查询销售订单类型
     *
     * @param id 销售订单类型主键
     * @return 销售订单类型
     */
    public MdSaleOrderType selectMdSaleOrderTypeById(Long id);

    /**
     * 查询销售订单类型列表
     *
     * @param mdSaleOrderType 销售订单类型
     * @return 销售订单类型集合
     */
    public List<MdSaleOrderType> selectMdSaleOrderTypeList(MdSaleOrderType mdSaleOrderType);

    /**
     * 新增销售订单类型
     *
     * @param mdSaleOrderType 销售订单类型
     * @return 结果
     */
    public int insertMdSaleOrderType(MdSaleOrderType mdSaleOrderType);

    /**
     * 修改销售订单类型
     *
     * @param mdSaleOrderType 销售订单类型
     * @return 结果
     */
    public int updateMdSaleOrderType(MdSaleOrderType mdSaleOrderType);

    /**
     * 批量删除销售订单类型
     *
     * @param ids 需要删除的销售订单类型主键集合
     * @return 结果
     */
    public int deleteMdSaleOrderTypeByIds(Long[] ids);

    /**
     * 删除销售订单类型信息
     *
     * @param id 销售订单类型主键
     * @return 结果
     */
    public int deleteMdSaleOrderTypeById(Long id);
}
