package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdProductLoss;
import com.ximai.mes.md.vo.MdProductLossVo;

/**
 * 产品loss配置Service接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface IMdProductLossService
{
    /**
     * 查询产品loss配置
     *
     * @param productLossId 产品loss配置主键
     * @return 产品loss配置
     */
    public MdProductLossVo selectMdProductLossByProductLossId(Long productLossId);

    /**
     * 查询产品loss配置列表
     *
     * @param mdProductLoss 产品loss配置
     * @return 产品loss配置集合
     */
    public List<MdProductLossVo> selectMdProductLossList(MdProductLoss mdProductLoss);

    /**
     * 新增产品loss配置
     *
     * @param mdProductLoss 产品loss配置
     * @return 结果
     */
    public int insertMdProductLoss(MdProductLoss mdProductLoss);

    /**
     * 修改产品loss配置
     *
     * @param mdProductLoss 产品loss配置
     * @return 结果
     */
    public int updateMdProductLoss(MdProductLoss mdProductLoss);

    /**
     * 批量删除产品loss配置
     *
     * @param productLossIds 需要删除的产品loss配置主键集合
     * @return 结果
     */
    public int deleteMdProductLossByProductLossIds(Long[] productLossIds);

    /**
     * 删除产品loss配置信息
     *
     * @param productLossId 产品loss配置主键
     * @return 结果
     */
    public int deleteMdProductLossByProductLossId(Long productLossId);
}
