package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdProductFactory;
import com.ximai.mes.md.vo.MdProductFactoryVo;

/**
 * 产品工厂配置Service接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface IMdProductFactoryService
{
    /**
     * 查询产品工厂配置
     *
     * @param productFactoryId 产品工厂配置主键
     * @return 产品工厂配置
     */
    public MdProductFactory selectMdProductFactoryByProductFactoryId(Long productFactoryId);

    /**
     * 查询产品工厂配置列表
     *
     * @param mdProductFactory 产品工厂配置
     * @return 产品工厂配置集合
     */
    public List<MdProductFactoryVo> selectMdProductFactoryList(MdProductFactory mdProductFactory);

    /**
     * 新增产品工厂配置
     *
     * @param mdProductFactory 产品工厂配置
     * @return 结果
     */
    public int insertMdProductFactory(MdProductFactory mdProductFactory);

    /**
     * 修改产品工厂配置
     *
     * @param mdProductFactory 产品工厂配置
     * @return 结果
     */
    public int updateMdProductFactory(MdProductFactory mdProductFactory);

    /**
     * 批量删除产品工厂配置
     *
     * @param productFactoryIds 需要删除的产品工厂配置主键集合
     * @return 结果
     */
    public int deleteMdProductFactoryByProductFactoryIds(Long[] productFactoryIds);

    /**
     * 删除产品工厂配置信息
     *
     * @param productFactoryId 产品工厂配置主键
     * @return 结果
     */
    public int deleteMdProductFactoryByProductFactoryId(Long productFactoryId);
}
