package com.ximai.mes.md.service;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.md.domain.MdItemWarehouse;
import com.ximai.mes.md.dto.MdItemWarehouseCreate;
import com.ximai.mes.md.dto.MdItemWarehouseUpdate;
import com.ximai.mes.md.dto.MdItemWarehouseDto;

/**
 * 物料仓库Service接口
 * 
 * @author generator
 * @date 2024-10-20
 */
public interface IMdItemWarehouseService 
{
    /**
     * 查询物料仓库
     *
     * @param itemWarehouseId 物料仓库主键
     * @return 物料仓库
     */
    public MdItemWarehouseDto selectMdItemWarehouseDtoByItemWarehouseId(Long itemWarehouseId);

    /**
     * 查询物料仓库
     *
     * @param itemWarehouseId 物料仓库主键
     * @return 物料仓库
     */
    public MdItemWarehouse selectMdItemWarehouseByItemWarehouseId(Long itemWarehouseId);

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouse 物料仓库
     * @return 物料仓库集合
     */
    public List<MdItemWarehouseDto> selectMdItemWarehouseList(MdItemWarehouse mdItemWarehouse);

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouseQuery 物料仓库
     * @return 物料仓库集合
     */
    public List<MdItemWarehouse> selectMdItemWarehouseList(QueryWrapper<MdItemWarehouse> mdItemWarehouseQuery);

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouseQuery 物料仓库
     * @return 物料仓库集合
     */
    public List<MdItemWarehouseDto> selectMdItemWarehouseDtoList(QueryWrapper<MdItemWarehouse> mdItemWarehouseQuery);

    /**
     * 新增物料仓库
     * 
     * @param mdItemWarehouse 物料仓库
     * @return 结果
     */
    public int insertMdItemWarehouse(MdItemWarehouseCreate mdItemWarehouse);

    /**
     * 修改物料仓库
     * 
     * @param mdItemWarehouse 物料仓库
     * @return 结果
     */
    public int updateMdItemWarehouse(MdItemWarehouseUpdate mdItemWarehouse);

    /**
     * 批量删除物料仓库
     * 
     * @param itemWarehouseIds 需要删除的物料仓库主键集合
     * @return 结果
     */
    public int deleteMdItemWarehouseByItemWarehouseIds(Long[] itemWarehouseIds);

    /**
     * 删除物料仓库信息
     * 
     * @param itemWarehouseId 物料仓库主键
     * @return 结果
     */
    public int deleteMdItemWarehouseByItemWarehouseId(Long itemWarehouseId);
}
