package com.ximai.mes.md.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.md.domain.MdWorkstation;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 工作站Mapper接口
 *
 * @date 2022-05-10
 */
public interface MdWorkstationMapper {
    @Select(value = "select * from md_workstation \n" +
            "${ew.customSqlSegment}")
    List<MdWorkstation> selectListByQw(@Param("ew") QueryWrapper<MdWorkstation> query);


    /**
     * 查询工作站
     *
     * @param workstationId 工作站主键
     * @return 工作站
     */
    MdWorkstation selectMdWorkstationByWorkstationId(Long workstationId);

    @Select("select *from md_workstation where workstation_id=#{workstationId}")
    MdWorkstation selectMdWorkstationByWorkstationIds(@Param("workstationId") Long workstationId);


    @Select("select *from md_workstation where workstation_code=#{workstationCode}")
    List<MdWorkstation> selectMdWorkstationByWorkstationCode(@Param("workstationCode") String workstationCode);

    @Select("select *from md_workstation where workstation_code=#{workstationCode}")
    MdWorkstation selectMdWorkstationByWorkstationCodes(@Param("workstationCode") String workstationCode);

    /**
     * 查询人员关联工作中心
     *
     * @param userId
     * @return
     */
    @Select("select * from md_workstation t1 left join md_workstation_worker t2 on \n" +
            "t1.workstation_id = t2.workstation_id where t2.user_id = #{userId}")
    List<MdWorkstation> selectWorkstationByUserId(@Param("userId") Long userId);


    /**
     * 查询人员关联工作中心
     *
     * @param userId
     * @return
     */
    @Select("select * from md_workstation t1 inner join (select x1.*,x2.workstation_id from md_workunit_worker x1 inner join md_workunit x2 on x1.workunit_id = x2.workunit_id) t2 on t1.workstation_id = t2.workstation_id where t2.user_id = #{userId}")
    List<MdWorkstation> selectWorkstationByUserIdV2(@Param("userId") Long userId);


    /**
     * 查询工作站列表
     *
     * @param mdWorkstation 工作站
     * @return 工作站集合
     */
    List<MdWorkstation> selectMdWorkstationList(MdWorkstation mdWorkstation);

    MdWorkstation checkWorkStationCodeUnique(MdWorkstation mdWorkstation);

    MdWorkstation checkWorkStationNameUnique(MdWorkstation mdWorkstation);


    /**
     * 新增工作站
     *
     * @param mdWorkstation 工作站
     * @return 结果
     */
    int insertMdWorkstation(MdWorkstation mdWorkstation);

    /**
     * 修改工作站
     *
     * @param mdWorkstation 工作站
     * @return 结果
     */
    int updateMdWorkstation(MdWorkstation mdWorkstation);

    /**
     * 删除工作站
     *
     * @param workstationId 工作站主键
     * @return 结果
     */
    int deleteMdWorkstationByWorkstationId(Long workstationId);


    /**
     * 根据ep工作站编码删除数据
     *
     * @param workstationCode
     * @return
     */
    @Delete("delete from  md_workstation where workstation_code=#{workstationCode}")
    int deleteMdWorkstationByWorkstationCode(@Param("workstationCode") String workstationCode);

    /**
     * 批量删除工作站
     *
     * @param workstationIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteMdWorkstationByWorkstationIds(Long[] workstationIds);
}
