package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdSaleUnit;
import com.ximai.mes.md.vo.MdSaleUnitVo;

/**
 * 销售单位转换Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface MdSaleUnitMapper
{
    /**
     * 查询销售单位转换
     *
     * @param id 销售单位转换主键
     * @return 销售单位转换
     */
    public MdSaleUnitVo selectMdSaleUnitById(Long id);

    /**
     * 查询销售单位转换列表
     *
     * @param mdSaleUnit 销售单位转换
     * @return 销售单位转换集合
     */
    public List<MdSaleUnitVo> selectMdSaleUnitList(MdSaleUnit mdSaleUnit);

    /**
     * 新增销售单位转换
     *
     * @param mdSaleUnit 销售单位转换
     * @return 结果
     */
    public int insertMdSaleUnit(MdSaleUnit mdSaleUnit);

    /**
     * 修改销售单位转换
     *
     * @param mdSaleUnit 销售单位转换
     * @return 结果
     */
    public int updateMdSaleUnit(MdSaleUnit mdSaleUnit);

    /**
     * 删除销售单位转换
     *
     * @param id 销售单位转换主键
     * @return 结果
     */
    public int deleteMdSaleUnitById(Long id);

    /**
     * 批量删除销售单位转换
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdSaleUnitByIds(Long[] ids);
}
