package com.ximai.mes.md.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.md.domain.MdItemWarehouse;
import com.ximai.mes.md.dto.MdItemWarehouseDto;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

/**
 * 物料仓库Mapper接口
 *
 * @author generator
 * @date 2024-10-20
 */
public interface MdItemWarehouseMapper extends BaseMapper<MdItemWarehouse>
{
    /**
     * 查询物料仓库
     *
     * @param itemWarehouseId 物料仓库主键
     * @return 物料仓库
     */
    public MdItemWarehouseDto selectMdItemWarehouseByItemWarehouseId(Long itemWarehouseId);

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouse 物料仓库
     * @return 物料仓库集合
     */
    public List<MdItemWarehouseDto> selectMdItemWarehouseList(MdItemWarehouse mdItemWarehouse);

    /**
     * 查询物料仓库列表
     *
     * @param mdItemWarehouseQuery 物料仓库
     * @return 物料仓库集合
     */
    @Select("select m.* from md_item_warehouse m ${ew.customSqlSegment}")
    public List<MdItemWarehouseDto> selectDtoListByQw(@Param("ew") QueryWrapper<MdItemWarehouse> mdItemWarehouseQuery);

    /**
     * 新增物料仓库
     *
     * @param mdItemWarehouse 物料仓库
     * @return 结果
     */
    public int insertMdItemWarehouse(MdItemWarehouse mdItemWarehouse);

    /**
     * 修改物料仓库
     *
     * @param mdItemWarehouse 物料仓库
     * @return 结果
     */
    public int updateMdItemWarehouse(MdItemWarehouse mdItemWarehouse);

    /**
     * 删除物料仓库
     *
     * @param itemWarehouseId 物料仓库主键
     * @return 结果
     */
    public int deleteMdItemWarehouseByItemWarehouseId(Long itemWarehouseId);

    /**
     * 批量删除物料仓库
     *
     * @param itemWarehouseIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdItemWarehouseByItemWarehouseIds(Long[] itemWarehouseIds);
}
