package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdColor;

/**
 * 颜色主数据Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public interface MdColorMapper
{
    /**
     * 查询颜色主数据
     *
     * @param colorId 颜色主数据主键
     * @return 颜色主数据
     */
    public MdColor selectMdColorByColorId(Long colorId);

    /**
     * 查询颜色主数据列表
     *
     * @param mdColor 颜色主数据
     * @return 颜色主数据集合
     */
    public List<MdColor> selectMdColorList(MdColor mdColor);

    /**
     * 新增颜色主数据
     *
     * @param mdColor 颜色主数据
     * @return 结果
     */
    public int insertMdColor(MdColor mdColor);

    /**
     * 修改颜色主数据
     *
     * @param mdColor 颜色主数据
     * @return 结果
     */
    public int updateMdColor(MdColor mdColor);

    /**
     * 删除颜色主数据
     *
     * @param colorId 颜色主数据主键
     * @return 结果
     */
    public int deleteMdColorByColorId(Long colorId);

    /**
     * 批量删除颜色主数据
     *
     * @param colorIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdColorByColorIds(Long[] colorIds);
}
