package com.ximai.mes.md.mapper;

import com.ximai.mes.md.domain.MdClientPaymentRelation;

import java.util.List;

/**
 * 客户付款信息关联Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
public interface MdClientPaymentRelationMapper {
    /**
     * 查询客户付款信息关联
     *
     * @param id 客户付款信息关联主键
     * @return 客户付款信息关联
     */
    MdClientPaymentRelation selectMdClientPaymentRelationById(String id);

    /**
     * 查询客户付款信息关联列表
     *
     * @param mdClientPaymentRelation 客户付款信息关联
     * @return 客户付款信息关联集合
     */
    List<MdClientPaymentRelation> selectMdClientPaymentRelationList(MdClientPaymentRelation mdClientPaymentRelation);

    /**
     * 新增客户付款信息关联
     *
     * @param mdClientPaymentRelation 客户付款信息关联
     * @return 结果
     */
    int insertMdClientPaymentRelation(MdClientPaymentRelation mdClientPaymentRelation);

    /**
     * 修改客户付款信息关联
     *
     * @param mdClientPaymentRelation 客户付款信息关联
     * @return 结果
     */
    int updateMdClientPaymentRelation(MdClientPaymentRelation mdClientPaymentRelation);

    /**
     * 删除客户付款信息关联
     *
     * @param id 客户付款信息关联主键
     * @return 结果
     */
    int deleteMdClientPaymentRelationById(String id);

    /**
     * 批量删除客户付款信息关联
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteMdClientPaymentRelationByIds(String[] ids);
}
