package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdClientContact;

/**
 * 客户系人Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
public interface MdClientContactMapper
{
    /**
     * 查询客户系人
     *
     * @param id 客户系人主键
     * @return 客户系人
     */
    public MdClientContact selectMdClientContactById(String id);

    /**
     * 查询客户系人列表
     *
     * @param mdClientContact 客户系人
     * @return 客户系人集合
     */
    public List<MdClientContact> selectMdClientContactList(MdClientContact mdClientContact);

    /**
     * 新增客户系人
     *
     * @param mdClientContact 客户系人
     * @return 结果
     */
    public int insertMdClientContact(MdClientContact mdClientContact);

    /**
     * 修改客户系人
     *
     * @param mdClientContact 客户系人
     * @return 结果
     */
    public int updateMdClientContact(MdClientContact mdClientContact);

    /**
     * 删除客户系人
     *
     * @param id 客户系人主键
     * @return 结果
     */
    public int deleteMdClientContactById(String id);

    /**
     * 批量删除客户系人
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdClientContactByIds(String[] ids);
}
