package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModel;
import lombok.Data;

/**
 * 工厂对象 md_factory
 *
 * @author yinjinlu
 * @date 2024-01-18
 */

@Data
@ApiModel("工厂导出")
public class MdFactoryExcelExport extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 工厂id
     */
    private Long factoryId;

    /**
     * 工厂编码
     */
    @ExcelProperty("工厂编码")
    private String factoryCode;

    /**
     * 工厂名称
     */
    @ExcelProperty("工厂名称")
    private String factoryName;

    /**
     * 是否启用
     */
    @ExcelProperty("是否启用")
    private String enableFlag;
}
