package com.ximai.mes.md.domain;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import lombok.Data;

/**
 * Sap特性视图对象 md_sap_view
 *
 * @author generator
 * @date 2024-01-31
 */
@Data
public class MdSapField {

    /**  */
    @TableId(type = IdType.AUTO)
    private Long id;

    /** 特性类型 */
    @Excel(name = "特性类型")
    private String type;

    /** 数据类型 {@link DataType} */
    @Excel(name = "数据类型")
    private String dataType;

    /** 视图名称 */
    @Excel(name = "视图名称")
    private String name;

    /** 视图属性 */
    @Excel(name = "视图属性")
    private String field;

    /** sap属性 */
    @Excel(name = "sap属性")
    private String sapField;

    /** 默认值 */
    @Excel(name = "默认值")
    private String defaultValue;

    /** 是否必填 */
    @Excel(name = "是否必填")
    private String required;

    /** 是否显示 */
    @Excel(name = "是否显示")
    private String show;

    /** 错误提示语 */
    @Excel(name = "错误提示语")
    private String errMsg;

    /** 长度 */
    @Excel(name = "长度")
    private String length;

    /** 最小值 */
    @Excel(name = "最小值")
    private String min;

    /** 最大值 */
    @Excel(name = "最大值")
    private String max;

    /** 正则 */
    @Excel(name = "正则")
    private String regEx;

    /** 字典ID */
    @Excel(name = "字典ID")
    private String dictId;

    /** 父级ID */
    @Excel(name = "父级ID")
    private String parentId;

    private String createBy;

    private Date createTime;

    private String updateBy;

    private Date updateTime;

    @TableField(exist = false)
    private List<MdSapField> subList;

    public Boolean getHasChildren() {
        return DataType.objOrArr().contains(this.dataType);
    }

    public interface DataType {
        /**
         * 字符串
         */
        String str = "1";
        /**
         * 数字
         */
        String num = "2";
        /**
         * 金额
         */
        String amt = "3";
        /**
         * 日期
         */
        String date = "4";
        /**
         * 时间
         */
        String time = "5";
        /**
         * 日期时间
         */
        String datetime = "6";
        /**
         * 字典
         */
        String dict = "7";
        /**
         * 字典列表
         */
        String dicts = "8";
        /**
         * 对象
         */
        String obj = "9";
        /**
         * 列表
         */
        String arr = "10";

        static List<String> objOrArr() {
            return Arrays.asList(obj, arr);
        }
    }
}
