package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 销售订单办事处对象 md_sale_order_office
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public class MdSaleOrderOffice extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 销售订单办事处编码 */
    @Excel(name = "销售订单办事处编码")
    private String code;

    /** 销售订单办事处名称 */
    @Excel(name = "销售订单办事处名称")
    private String name;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId()
    {
        return id;
    }
    public void setCode(String code)
    {
        this.code = code;
    }

    public String getCode()
    {
        return code;
    }
    public void setName(String name)
    {
        this.name = name;
    }

    public String getName()
    {
        return name;
    }
    public void setEnableFlag(String enableFlag)
    {
        this.enableFlag = enableFlag;
    }

    public String getEnableFlag()
    {
        return enableFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("code", getCode())
            .append("name", getName())
            .append("enableFlag", getEnableFlag())
            .append("remark", getRemark())
            .toString();
    }
}
