package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 产品客户配置对象 md_product_customer
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public class MdProductCustomer extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品客户id */
    private Long productCustomerId;

    /** 产品id */
    @Excel(name = "产品id")
    private Long itemId;

    /** 客户编码 */
    @Excel(name = "客户编码")
    private String customerCode;

    /** 客户名称 */
    @Excel(name = "客户名称")
    private String customerName;

    public void setProductCustomerId(Long productCustomerId)
    {
        this.productCustomerId = productCustomerId;
    }

    public Long getProductCustomerId()
    {
        return productCustomerId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setCustomerCode(String customerCode)
    {
        this.customerCode = customerCode;
    }

    public String getCustomerCode()
    {
        return customerCode;
    }
    public void setCustomerName(String customerName)
    {
        this.customerName = customerName;
    }

    public String getCustomerName()
    {
        return customerName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("productCustomerId", getProductCustomerId())
            .append("itemId", getItemId())
            .append("customerCode", getCustomerCode())
            .append("customerName", getCustomerName())
            .toString();
    }
}
