package com.ximai.mes.md.domain;

import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * 品牌表
 *
 * @TableName md_brand
 */
public class MdBrand implements Serializable {

    /**
     *
     */
    @NotNull(message = "[]不能为空")
    @ApiModelProperty("")
    private Long brandId;
    /**
     * 编码
     */
    @Size(max = 10, message = "编码长度不能超过10")
    @ApiModelProperty("编码")
    @Length(max = 10, message = "编码长度不能超过10")
    @Excel(name = "编码")
    private String brandCode;
    /**
     * 名称
     */
    @Size(max = 32, message = "编码长度不能超过32")
    @ApiModelProperty("名称")
    @Length(max = 32, message = "编码长度不能超过32")
    @Excel(name = "名称")
    private String brandName;
    /**
     * 集团
     */
    @Size(max = 32, message = "编码长度不能超过32")
    @ApiModelProperty("集团")
    @Length(max = 32, message = "编码长度不能超过32")
    @Excel(name = "集团")
    private String groupName;
    /**
     * 地址
     */
    @Size(max = 500, message = "编码长度不能超过500")
    @ApiModelProperty("地址")
    @Length(max = 500, message = "编码长度不能超过500")
    @Excel(name = "地址")
    private String address;
    /**
     * 销售对接人
     */
    @Size(max = 32, message = "编码长度不能超过32")
    @ApiModelProperty("销售对接人")
    @Length(max = 32, message = "编码长度不能超过32")
    @Excel(name = "销售对接人")
    private String salesContact;
    /**
     * 开发对接人
     */
    @Size(max = 32, message = "编码长度不能超过32")
    @ApiModelProperty("开发对接人")
    @Length(max = 32, message = "编码长度不能超过32")
    @Excel(name = "开发对接人")
    private String devContact;
    /**
     * 背景
     */
    @Size(max = 500, message = "编码长度不能超过500")
    @ApiModelProperty("背景")
    @Length(max = 500, message = "编码长度不能超过500")
    @Excel(name = "品牌背景")
    private String background;
    /**
     * 经营范围
     */
    @Size(max = 255, message = "编码长度不能超过255")
    @ApiModelProperty("经营范围")
    @Length(max = 255, message = "编码长度不能超过255")
    @Excel(name = "经营范围")
    private String scope;
    /**
     * 潜力项目
     */
    @Size(max = 255, message = "编码长度不能超过255")
    @ApiModelProperty("潜力项目")
    @Length(max = 255, message = "编码长度不能超过255")
    @Excel(name = "潜力项目")
    private String potentialProject;
    /**
     * 廉洁规定
     */
    @Size(max = 255, message = "编码长度不能超过255")
    @ApiModelProperty("廉洁规定")
    @Length(max = 255, message = "编码长度不能超过255")
    @Excel(name = "廉洁规定")
    private String integrityRegulations;
    /**
     * 备注
     */
    @Size(max = 500, message = "编码长度不能超过500")
    @ApiModelProperty("备注")
    @Length(max = 500, message = "编码长度不能超过500")
    @Excel(name = "备注")
    private String remark;
    /**
     * 是否启用
     */
    @ApiModelProperty("是否启用")
    @Excel(name = "是否启用")
    private String enableFlag;
    /**
     * 创建者
     */
    @Size(max = 64, message = "编码长度不能超过64")
    @ApiModelProperty("创建者")
    @Length(max = 64, message = "编码长度不能超过64")
    private String createBy;
    /**
     * 创建日期
     */
    @ApiModelProperty("创建日期")
    private Date createTime;
    /**
     * 更新者
     */
    @Size(max = 64, message = "编码长度不能超过64")
    @ApiModelProperty("更新者")
    @Length(max = 64, message = "编码长度不能超过64")
    private String updateBy;
    /**
     * 更新日期
     */
    @ApiModelProperty("更新日期")
    private Date updateTime;

    public Long getBrandId() {
        return brandId;
    }

    public void setBrandId(Long brandId) {
        this.brandId = brandId;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getGroupName() {
        return groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getSalesContact() {
        return salesContact;
    }

    public void setSalesContact(String salesContact) {
        this.salesContact = salesContact;
    }

    public String getDevContact() {
        return devContact;
    }

    public void setDevContact(String devContact) {
        this.devContact = devContact;
    }

    public String getBackground() {
        return background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getPotentialProject() {
        return potentialProject;
    }

    public void setPotentialProject(String potentialProject) {
        this.potentialProject = potentialProject;
    }

    public String getIntegrityRegulations() {
        return integrityRegulations;
    }

    public void setIntegrityRegulations(String integrityRegulations) {
        this.integrityRegulations = integrityRegulations;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getEnableFlag() {
        return enableFlag;
    }

    public void setEnableFlag(String enableFlag) {
        this.enableFlag = enableFlag;
    }

    public String getCreateBy() {
        return createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
