package com.ximai.mes.md.controller;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.md.domain.MdSapFieldData;
import com.ximai.mes.md.service.MdSapFieldDataService;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * @since created by hyy on 2024-02-22
 */
@Slf4j
@RestController
@AllArgsConstructor
@RequestMapping("md/sapFieldData")
public class MdSapFieldDataController {

    private final MdSapFieldDataService sapFieldDataService;

    @PostMapping("page")
    public AjaxResult page(@RequestBody Map<String, Object> params) {
        final Integer type = MapUtil.getInt(params, "type");
        final Integer current = MapUtil.getInt(params, "current");
        final Integer size = MapUtil.getInt(params, "size");

        final LambdaQueryWrapper<MdSapFieldData> wrapper = Wrappers.<MdSapFieldData>lambdaQuery()
                .eq(type != null, MdSapFieldData::getType, type);
        final Page<MdSapFieldData> page = sapFieldDataService.page(new Page<>(current, size), wrapper);
        return AjaxResult.success(page);
    }

    @GetMapping
    public AjaxResult get(MdSapFieldData query) {
        final LambdaQueryWrapper<MdSapFieldData> wrapper = Wrappers.<MdSapFieldData>lambdaQuery()
                .eq(query.getId() != null, MdSapFieldData::getId, query.getId())
                .eq(query.getType() != null, MdSapFieldData::getType, query.getType())
                .eq(query.getRelationId() != null, MdSapFieldData::getRelationId, query.getRelationId())
                .eq(query.getTypeView() != null, MdSapFieldData::getTypeView, query.getTypeView())
                .last("limit 1");
        final MdSapFieldData sapFieldData = sapFieldDataService.getOne(wrapper);
        return AjaxResult.success(sapFieldData);
    }
}
