package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSalesReason;
import com.ximai.mes.md.service.IMdSalesReasonService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单原因Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/reason")
public class MdSalesReasonController extends BaseController
{
    @Autowired
    private IMdSalesReasonService mdSalesReasonService;

    /**
     * 查询销售订单原因列表
     */
    @PreAuthorize("@ss.hasPermi('md:reason:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSalesReason mdSalesReason)
    {
        startPage();
        List<MdSalesReason> list = mdSalesReasonService.selectMdSalesReasonList(mdSalesReason);
        return getDataTable(list);
    }


    /**
     * 获取销售订单原因详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:reason:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id)
    {
        return AjaxResult.success(mdSalesReasonService.selectMdSalesReasonById(id));
    }

    /**
     * 新增销售订单原因
     */
    @PreAuthorize("@ss.hasPermi('md:reason:add')")
    @Log(title = "销售订单原因", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSalesReason mdSalesReason)
    {
        return toAjax(mdSalesReasonService.insertMdSalesReason(mdSalesReason));
    }

    /**
     * 修改销售订单原因
     */
    @PreAuthorize("@ss.hasPermi('md:reason:edit')")
    @Log(title = "销售订单原因", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSalesReason mdSalesReason)
    {
        return toAjax(mdSalesReasonService.updateMdSalesReason(mdSalesReason));
    }

    /**
     * 删除销售订单原因
     */
    @PreAuthorize("@ss.hasPermi('md:reason:remove')")
    @Log(title = "销售订单原因", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids)
    {
        return toAjax(mdSalesReasonService.deleteMdSalesReasonByIds(ids));
    }
}
