package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.md.vo.MdSaleUnitVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSaleUnit;
import com.ximai.mes.md.service.IMdSaleUnitService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售单位转换Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/unit")
public class MdSaleUnitController extends BaseController
{
    @Autowired
    private IMdSaleUnitService mdSaleUnitService;

    /**
     * 查询销售单位转换列表
     */
    @PreAuthorize("@ss.hasPermi('md:unit:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSaleUnit mdSaleUnit)
    {
        startPage();
        List<MdSaleUnitVo> list = mdSaleUnitService.selectMdSaleUnitList(mdSaleUnit);
        return getDataTable(list);
    }


    /**
     * 获取销售单位转换详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:unit:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(mdSaleUnitService.selectMdSaleUnitById(id));
    }

    /**
     * 新增销售单位转换
     */
    @PreAuthorize("@ss.hasPermi('md:unit:add')")
    @Log(title = "销售单位转换", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSaleUnit mdSaleUnit)
    {
        return toAjax(mdSaleUnitService.insertMdSaleUnit(mdSaleUnit));
    }

    /**
     * 修改销售单位转换
     */
    @PreAuthorize("@ss.hasPermi('md:unit:edit')")
    @Log(title = "销售单位转换", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSaleUnit mdSaleUnit)
    {
        return toAjax(mdSaleUnitService.updateMdSaleUnit(mdSaleUnit));
    }

    /**
     * 删除销售单位转换
     */
    @PreAuthorize("@ss.hasPermi('md:unit:remove')")
    @Log(title = "销售单位转换", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mdSaleUnitService.deleteMdSaleUnitByIds(ids));
    }
}
