package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSaleOrderChannel;
import com.ximai.mes.md.service.IMdSaleOrderChannelService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 销售订单分销渠道Controller
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/md/channel")
public class MdSaleOrderChannelController extends BaseController
{
    @Autowired
    private IMdSaleOrderChannelService mdSaleOrderChannelService;

    /**
     * 查询销售订单分销渠道列表
     */
    @PreAuthorize("@ss.hasPermi('md:channel:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdSaleOrderChannel mdSaleOrderChannel)
    {
        startPage();
        List<MdSaleOrderChannel> list = mdSaleOrderChannelService.selectMdSaleOrderChannelList(mdSaleOrderChannel);
        return getDataTable(list);
    }
    /**
     * 获取销售订单分销渠道详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:channel:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(mdSaleOrderChannelService.selectMdSaleOrderChannelById(id));
    }

    /**
     * 新增销售订单分销渠道
     */
    @PreAuthorize("@ss.hasPermi('md:channel:add')")
    @Log(title = "销售订单分销渠道", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSaleOrderChannel mdSaleOrderChannel)
    {
        return toAjax(mdSaleOrderChannelService.insertMdSaleOrderChannel(mdSaleOrderChannel));
    }

    /**
     * 修改销售订单分销渠道
     */
    @PreAuthorize("@ss.hasPermi('md:channel:edit')")
    @Log(title = "销售订单分销渠道", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSaleOrderChannel mdSaleOrderChannel)
    {
        return toAjax(mdSaleOrderChannelService.updateMdSaleOrderChannel(mdSaleOrderChannel));
    }

    /**
     * 删除销售订单分销渠道
     */
    @PreAuthorize("@ss.hasPermi('md:channel:remove')")
    @Log(title = "销售订单分销渠道", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mdSaleOrderChannelService.deleteMdSaleOrderChannelByIds(ids));
    }
}
