package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdClientUrgeEmail;
import com.ximai.mes.md.service.IMdClientUrgeEmailService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 催货款通知邮箱Controller
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@RestController
@RequestMapping("/md/clientUrgeEmail")
public class MdClientUrgeEmailController extends BaseController {
    @Autowired
    private IMdClientUrgeEmailService mdClientUrgeEmailService;

    /**
     * 查询催货款通知邮箱列表
     */
//    @PreAuthorize("@ss.hasPermi('md:clientUrgeEmail:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdClientUrgeEmail mdClientUrgeEmail) {
        startPage();
        List<MdClientUrgeEmail> list = mdClientUrgeEmailService.selectMdClientUrgeEmailList(mdClientUrgeEmail);
        return getDataTable(list);
    }


    /**
     * 获取催货款通知邮箱详细信息
     */
//    @PreAuthorize("@ss.hasPermi('md:clientUrgeEmail:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(mdClientUrgeEmailService.selectMdClientUrgeEmailById(id));
    }

    /**
     * 新增催货款通知邮箱
     */
//    @PreAuthorize("@ss.hasPermi('md:clientUrgeEmail:add')")
    @Log(title = "催货款通知邮箱", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdClientUrgeEmail mdClientUrgeEmail) {
        return toAjax(mdClientUrgeEmailService.insertMdClientUrgeEmail(mdClientUrgeEmail));
    }

    /**
     * 修改催货款通知邮箱
     */
//    @PreAuthorize("@ss.hasPermi('md:clientUrgeEmail:edit')")
    @Log(title = "催货款通知邮箱", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdClientUrgeEmail mdClientUrgeEmail) {
        return toAjax(mdClientUrgeEmailService.updateMdClientUrgeEmail(mdClientUrgeEmail));
    }

    /**
     * 删除催货款通知邮箱
     */
//    @PreAuthorize("@ss.hasPermi('md:clientUrgeEmail:remove')")
    @Log(title = "催货款通知邮箱", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(mdClientUrgeEmailService.deleteMdClientUrgeEmailByIds(ids));
    }
}
