package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import lombok.AllArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import com.ximai.mes.md.domain.MdClientAccount;
import com.ximai.mes.md.service.IMdClientAccountService;

/**
 * 客户付款信息Controller
 *
 * @author generator
 * @date 2024-01-27
 */
@RestController
@AllArgsConstructor
@RequestMapping("/md/mdClientAccount")
public class MdClientAccountController {

    private final IMdClientAccountService mdClientAccountService;

    /**
     * 查询客户产品对照列表
     */
    @PostMapping("/page")
    @PreAuthorize("@ss.hasPermi('md:clientItem:list')")
    public AjaxResult page(@RequestBody Map<String, Object> params) {
        return AjaxResult.success(mdClientAccountService.page(params));
    }

    /**
     * 查询客户付款信息列表
     */
    @GetMapping("/list")
    @PreAuthorize("@ss.hasPermi('md:mdClientAccount:list')")
    public AjaxResult list(MdClientAccount mdClientAccount) {
        List<MdClientAccount> list = mdClientAccountService.selectList(mdClientAccount);
        return AjaxResult.success(list);
    }


    /**
     * 获取客户付款信息详细信息
     */
    @GetMapping("/{id}")
    @PreAuthorize("@ss.hasPermi('md:mdClientAccount:query')")
    public AjaxResult get(@PathVariable("id") Long id) {
        return AjaxResult.success(mdClientAccountService.selectById(id));
    }

    /**
     * 新增客户付款信息
     */
    @PostMapping
    @PreAuthorize("@ss.hasPermi('md:mdClientAccount:add')")
    @Log(title = "客户付款信息", businessType = BusinessType.INSERT)
    public AjaxResult add(@RequestBody MdClientAccount mdClientAccount) {
        return mdClientAccountService.insert(mdClientAccount) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 修改客户付款信息
     */
    @PutMapping
    @PreAuthorize("@ss.hasPermi('md:mdClientAccount:edit')")
    @Log(title = "客户付款信息", businessType = BusinessType.UPDATE)
    public AjaxResult edit(@RequestBody MdClientAccount mdClientAccount) {
        return mdClientAccountService.update(mdClientAccount) ? AjaxResult.success() : AjaxResult.error();
    }

    /**
     * 删除客户付款信息
     */
	@DeleteMapping("/{ids}")
    @PreAuthorize("@ss.hasPermi('md:mdClientAccount:remove')")
    @Log(title = "客户付款信息", businessType = BusinessType.DELETE)
    public AjaxResult remove(@PathVariable List<Long> ids) {
        return mdClientAccountService.deleteByIds(ids) ? AjaxResult.success() : AjaxResult.error();
    }
}
