package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;


import com.ximai.mes.md.domain.MdBrand;
import com.ximai.mes.md.service.IMdBrandService;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdBrandVisit;
import com.ximai.mes.md.service.IMdBrandVisitService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/md/visit")
public class MdBrandVisitController extends BaseController {
    @Autowired
    private IMdBrandVisitService mdBrandVisitService;
    @Autowired
    private IMdBrandService mdBrandService;

    /**
     * 查询【请填写功能名称】列表
     */
    @PreAuthorize("@ss.hasPermi('md:visit:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdBrandVisit mdBrandVisit) {
        startPage();
        List<MdBrandVisit> list = mdBrandVisitService.selectMdBrandVisitList(mdBrandVisit);
        return getDataTable(list);
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:visit:query')")
    @GetMapping(value = "/{brandVisitId}")
    public AjaxResult getInfo(@PathVariable("brandVisitId") Long brandVisitId) {
        return AjaxResult.success(mdBrandVisitService.selectMdBrandVisitByBrandVisitId(brandVisitId));
    }

    /**
     * 新增【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:visit:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdBrandVisit mdBrandVisit) {
        return toAjax(mdBrandVisitService.insertMdBrandVisit(mdBrandVisit));
    }

    /**
     * 修改【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:visit:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdBrandVisit mdBrandVisit) {
        return toAjax(mdBrandVisitService.updateMdBrandVisit(mdBrandVisit));
    }

    /**
     * 删除【请填写功能名称】
     */
    @PreAuthorize("@ss.hasPermi('md:visit:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
    @DeleteMapping("/{brandVisitIds}")
    public AjaxResult remove(@PathVariable Long[] brandVisitIds) {
        return toAjax(mdBrandVisitService.deleteMdBrandVisitByBrandVisitIds(brandVisitIds));
    }

    /**
     * 查询品牌列表
     */
  @PreAuthorize("@ss.hasPermi('md:contact:listBrand')")
    @GetMapping("/listBrand")
    public AjaxResult list()
    {
        MdBrand mdBrand = new MdBrand();
        mdBrand.setEnableFlag("Y");
        List<MdBrand> list = mdBrandService.selectMdBrandList(mdBrand);
        return AjaxResult.success(list);
    }

}
