package com.ximai.mes.kanban.dto.material;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Data
public class ErpDataDto {

    @ApiModelProperty("物料配送完成率")
    BigDecimal stockInCompleteRatio;

    @ApiModelProperty("采购到货完成率")
    BigDecimal materialDistRatio;

    @ApiModelProperty("销售发货及时率")
    BigDecimal salesTimelyDeliveryRatio;

    @ApiModelProperty("库存趋势图")
    InventoryTrend inventoryTrend;

    @ApiModelProperty("销售出库计划")
    List<SalesOutboundPlan> salesOutboundPlanList=new ArrayList<>();

    @Data
    public static class InventoryTrend{

        @ApiModelProperty("生产入库趋势")
        List<BasicDailyData> stockInTrend=new ArrayList<>();

        @ApiModelProperty("发货出库趋势图")
        List<BasicDailyData> stockOutTrend=new ArrayList<>();

    }
    @Data
    public static class SalesOutboundPlan{
        @ApiModelProperty("通知单号")
        String outApplyNo;
        @ApiModelProperty("产品名称")
        String itemName;
        @ApiModelProperty("产品名称")
        String itemNo;
        @JsonFormat(pattern = "yyyyMMdd")
        @ApiModelProperty("计划出库时间")
        Date planOutDate;
        @ApiModelProperty("计划数量")
        BigDecimal planQuantity;
        @ApiModelProperty("已出库数量")
        BigDecimal outQuantity;
    }


}
