package com.ximai.mes.constant;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum WorkorderTypeEnum {

    /**
     * 待发布
     */
    COMPLEMENTS("complements","补数订单"),
    /**
     * 已发布
     */
    PROTOTYPE("prototype","打样订单"),
    /**
     * 已组合
     */
    ORDER("510","生产工单");

    /**
     * Lock type
     */
    private final String status;

    /**
     * 枚举名称
     */
    public String enumName;

    WorkorderTypeEnum(String status, String enumName) {
        this.status = status;
        this.enumName = enumName;
    }

    public String getEnumName() {
        return enumName;
    }
    /**
     * Constructor with field of type
     */
    private WorkorderTypeEnum(String status) {
        this.status = status;
    }

    public String getValue() {
        return status;
    }


    public static WorkorderTypeEnum get(String value) {
        for (WorkorderTypeEnum temp : WorkorderTypeEnum.values()) {
            if (temp.getValue().equals(value)) {
                return temp;
            }
        }
        return null;
    }
}
