package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum WorkorderSAPStatusEnum {
// 状态ID	状态短文本	状态描述
//I0001	CRTD 	已创建	不传MES  代表计划员开出生产工单，还不可以生产执行
//I0002	REL	已下达	传MES   代表可以执行生产的状态
//I0045	TECO	技术性完成	传MES  代表完工
//I0076	标记	删除标记	传MES  代表标记删除该工单  用于作废该生产工单
//I0043	锁定	已锁定	传MES   代表临时锁定该工单  不能生产 ：领料，发料，报工

    CREATE("I0001", "已创建"),

    RELEASED("I0002", "已下达"),
    COMPLETED("I0045", "完工"),
    LOCK("I0043", "锁定"),
    CANCAL("I0076", "取消"),
    ;

    /**
     * Lock type
     */
    private final String status;

    private final String statusCn;

    WorkorderSAPStatusEnum(String status, String statusCn) {
        this.status = status;
        this.statusCn = statusCn;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusCn() {
        return statusCn;
    }


    public static WorkorderSAPStatusEnum get(String status) {
        for (WorkorderSAPStatusEnum temp : WorkorderSAPStatusEnum.values()) {
            if (temp.getStatus().equals(status)) {
                return temp;
            }
        }
        return null;
    }


    public static String getStatusCn(String status) {
        for (WorkorderSAPStatusEnum temp : WorkorderSAPStatusEnum.values()) {
            if (temp.getStatus().equals(status)) {
                return temp.getStatusCn();
            }
        }
        return null;
    }

}
