package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum ProStartWorkEnum {

    /**
     * 暂停
     */
    NORMAL_STOP(0, "正常停止"),


    /**
     * 暂停
     */
    START(999, "开始"),
    CLOSE(4, "关闭"),

    /**
     * 暂停
     */
    SUSPENDED(1, "暂停"),

    /**
     * 异常
     */
    EXCEPTION(2, "异常"),

    /**
     * 报工
     */
    FEEDBACK(3, "报工");

    /**
     * Lock type
     */
    private final Integer type;

    private final String statusCn;

    ProStartWorkEnum(Integer type, String statusCn) {
        this.type = type;
        this.statusCn = statusCn;
    }

    public static ProStartWorkEnum get(Integer type) {
        for (ProStartWorkEnum temp : ProStartWorkEnum.values()) {
            if (temp.getType().equals(type)) {
                return temp;
            }
        }
        return null;
    }

    public Integer getType() {
        return type;
    }

    public String getStatusCn() {
        return statusCn;
    }


}
