package com.ximai.mes.cal.controller;

import cn.hutool.core.collection.CollUtil;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.mes.cal.domain.CalHoliday;
import com.ximai.mes.cal.domain.vo.CalCalendar;
import com.ximai.mes.cal.service.ICalCalendarService;
import com.ximai.mes.cal.service.ICalHolidayService;
import com.ximai.mes.cal.utils.MesCalendarUtil;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 排班日历
 *
 * @date 2022-06-10
 */
@RestController
@RequestMapping("/mes/cal/calendar")
public class CalCalendarController extends BaseController {

    @Autowired
    private ICalCalendarService calCalendarService;

    @Autowired
    private ICalHolidayService calHolidayService;

    @PreAuthorize("@ss.hasPermi('mes:cal:calendar:list')")
    @GetMapping("/list")
    public AjaxResult getCalendarByWorkunit(CalCalendar calCalendar) throws ParseException {
        Date day = new Date();
        String theDay = calCalendar.getTheDay();
        if (theDay != null && !"".equals(theDay)) {
            day = DateUtils.parseDate(theDay, "yyyy-MM-dd");
        }
        return AjaxResult.success(calCalendarService.getCalendarByWorkunit(day, calCalendar));
    }


    @PreAuthorize("@ss.hasPermi('mes:cal:calendar:list')")
    @GetMapping("/daylist")
    public AjaxResult getDayList(CalCalendar calCalendar) throws ParseException {
        Date day = new Date();
        String theDay = calCalendar.getTheDay();
        if (theDay != null && !"".equals(theDay)) {
            day = DateUtils.parseDate(theDay, "yyyy-MM-dd");
        }
        return AjaxResult.success(calCalendarService.dayList(day, calCalendar));
    }


    @PreAuthorize("@ss.hasPermi('mes:cal:calendar:list')")
    @PostMapping("/getCalWorkunits")
    public AjaxResult getCalWorkunits(@RequestBody CalCalendar calCalendar) throws ParseException {
        Date day = new Date();
        String theDay = calCalendar.getTheDay();
        if (theDay != null && !"".equals(theDay)) {
            day = DateUtils.parseDate(theDay, "yyyy-MM-dd");
        }
        return AjaxResult.success(calCalendarService.getCalWorkunits(day, calCalendar));
    }


    /**
     * 过滤掉节假日
     *
     * @param days
     * @return
     */
    private List<CalCalendar> getCalendarsWithoutHoliday(List<CalCalendar> days) {
        CalHoliday param = new CalHoliday();
        List<CalHoliday> holidays = calHolidayService.selectCalHolidayList(param);
        if (CollUtil.isNotEmpty(holidays)) {
            return days.stream().filter(
                    calCalendar -> holidays.stream().filter(calHoliday -> calCalendar.getTheDay().equals(MesCalendarUtil.getDateDayStr(calHoliday.getTheDay()))).collect(Collectors.toList()).size() == 0
            ).collect(Collectors.toList());
        }
        return days;
    }
}
