package com.ximai.web.controller.system;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.common.utils.excel.ExcelWriter;
import com.ximai.system.domain.SysPrintPrinterConfig;
import com.ximai.system.domain.SysUserAssocintionPrint;
import com.ximai.system.dto.SysPrintPrinterConfigExcelExport;
import com.ximai.system.mapper.SysPrintPrinterConfigMapper;
import com.ximai.system.mapper.SysUserAssocintionPrintMapper;
import com.ximai.system.service.ISysPrintPrinterConfigService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 打印机配置Controller
 *
 * @author generator
 * @date 2024-02-28
 */
@RestController
@RequestMapping("/system/printerConfig")
public class SysPrintPrinterConfigController extends BaseController {
    @Autowired
    private ISysPrintPrinterConfigService sysPrintPrinterConfigService;

    @Autowired
    private SysPrintPrinterConfigMapper sysPrintPrinterConfigMapper;

    @Autowired
    private SysUserAssocintionPrintMapper sysUserAssocintionPrintMapper;

    /**
     * 查询打印机配置列表
     */
    @PreAuthorize("@ss.hasPermi('system:printerConfig:list')")
    @GetMapping("/list")
    @ApiOperation("查询打印机配置列表")
    public TableDataInfo<SysPrintPrinterConfig> list(SysPrintPrinterConfig sysPrintPrinterConfig) {
        startPage();
        List<SysPrintPrinterConfig> list = sysPrintPrinterConfigService.selectSysPrintPrinterConfigList(sysPrintPrinterConfig);
        return getDataTable(list);
    }

    /**
     * 查询人员关联打印机
     */
    @PreAuthorize("@ss.hasPermi('system:printerConfig:list')")
    @GetMapping("/userList")
    @ApiOperation("查询作业端打印机配置列表")
    public TableDataInfo<SysPrintPrinterConfig> userPrinterList(SysPrintPrinterConfig sysPrintPrinterConfig) {

        SysUserAssocintionPrint sysUserAssocintionPrint = sysUserAssocintionPrintMapper.selectSysUserAssocintionPrintByUserPrintIdUserId2(sysPrintPrinterConfig.getUserId());
        List<SysPrintPrinterConfig> sysPrint= new ArrayList<>();
        QueryWrapper<SysPrintPrinterConfig> query = new QueryWrapper<SysPrintPrinterConfig>();
        startPage();
        List<SysPrintPrinterConfig> sysPrintPrinterConfigs = sysPrintPrinterConfigMapper.selectSysPrintPrinterConfigUserList(query);
        for( SysPrintPrinterConfig  sysPri:sysPrintPrinterConfigs){
            if(Objects.nonNull(sysUserAssocintionPrint)) {
                if (!StringUtils.isEmpty(sysUserAssocintionPrint.getPrinterId())) {
                    if (sysUserAssocintionPrint.getPrinterId().equals(sysPri.getPrinterId())) {
                        sysPri.setUserPrinterStatus("1");
                        sysPrint.add(sysPri);
                        continue;
                    }
                }
            }
            sysPri.setUserPrinterStatus("0");
            sysPrint.add(sysPri);
        }
        List<SysPrintPrinterConfig> collect = sysPrint.stream().sorted(Comparator.comparing(SysPrintPrinterConfig::getUserPrinterStatus).reversed()).collect(Collectors.toList());


        return getDataTable(collect);
    }

    /**
     * 获取打印机配置详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:printerConfig:query')")
    @GetMapping(value = "/{printerId}")
    public AjaxResult getInfo(@PathVariable("printerId") Long printerId) {
        return AjaxResult.success(sysPrintPrinterConfigService.selectSysPrintPrinterConfigByPrinterId(printerId));
    }

    /**
     * 新增打印机配置
     */
    @PreAuthorize("@ss.hasPermi('system:printerConfig:add')")
    @Log(title = "打印机配置", businessType = BusinessType.INSERT)
    @PostMapping
    @ApiOperation("打印机配置")
    public AjaxResult<SysPrintPrinterConfig> add(@RequestBody SysPrintPrinterConfig sysPrintPrinterConfig) {
        return toAjax(sysPrintPrinterConfigService.insertSysPrintPrinterConfig(sysPrintPrinterConfig));
    }

    /**
     * 修改打印机配置
     */
    @PreAuthorize("@ss.hasPermi('system:printerConfig:edit')")
    @Log(title = "打印机配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SysPrintPrinterConfig sysPrintPrinterConfig) {
        return toAjax(sysPrintPrinterConfigService.updateSysPrintPrinterConfig(sysPrintPrinterConfig));
    }

    /**
     * 删除打印机配置
     */
    @PreAuthorize("@ss.hasPermi('system:printerConfig:remove')")
    @Log(title = "打印机配置", businessType = BusinessType.DELETE)
    @DeleteMapping("/{printerIds}")
    public AjaxResult remove(@PathVariable Long[] printerIds) {
        return toAjax(sysPrintPrinterConfigService.deleteSysPrintPrinterConfigByPrinterIds(printerIds));
    }

    /**
     * 导出打印机配置列表
     */
    @PreAuthorize("@ss.hasPermi('system:printerConfig:export')")
    @Log(title = "打印机配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SysPrintPrinterConfig sysPrintPrinterConfig) throws IOException {
        List<SysPrintPrinterConfig> list = sysPrintPrinterConfigService.selectSysPrintPrinterConfigList(sysPrintPrinterConfig);
        List<SysPrintPrinterConfigExcelExport> listExport = BeanUtil.copyToList(list, SysPrintPrinterConfigExcelExport.class);
        ExcelWriter.write(response, SysPrintPrinterConfigExcelExport.class, listExport);
    }
}
