package com.ximai.system.service.impl;

import com.ximai.system.domain.SysApiLog;
import com.ximai.system.mapper.SysApiLogMapper;
import com.ximai.system.service.ISysApiLogService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 操作日志 服务层处理
 */
@Service
public class SysApiLogServiceImpl implements ISysApiLogService {
    @Autowired
    private SysApiLogMapper operApiMapper;

    /**
     * 新增操作日志
     *
     * @param operLog 操作日志对象
     */
    @Override
    public void insertApiLog(SysApiLog operLog) {
        operApiMapper.insertApiLog(operLog);
    }

    /**
     * 查询系统操作日志集合
     *
     * @param operLog 操作日志对象
     * @return 操作日志集合
     */
    @Override
    public List<SysApiLog> selectApiLogList(SysApiLog operLog) {
        return operApiMapper.selectApiLogList(operLog);
    }

    /**
     * 批量删除系统操作日志
     *
     * @param operIds 需要删除的操作日志ID
     * @return 结果
     */
    @Override
    public int deleteApiLogByIds(Long[] operIds) {
        return operApiMapper.deleteApiLogByIds(operIds);
    }

    /**
     * 查询操作日志详细
     *
     * @param operId 操作ID
     * @return 操作日志对象
     */
    @Override
    public SysApiLog selectApiLogById(Long operId) {
        return operApiMapper.selectApiLogById(operId);
    }

    /**
     * 清空操作日志
     */
    @Override
    public void cleanApiLog() {
        operApiMapper.cleanApiLog();
    }
}
