package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 工装夹具清单对象 tm_tool
 *
 * @date 2022-05-11
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class TmTool extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(exist = false)
    private Long toolMachinesId;


    /**
     * 工装夹具ID
     */
    @TableId
    private Long toolId;

    /**
     * 工装夹具编码
     */
    @Excel(name = "工装夹具编码")
    private String toolCode;

    /**
     * 工装夹具名称
     */
    @Excel(name = "工装夹具名称")
    private String toolName;

    /**
     * 品牌
     */
    @Excel(name = "品牌")
    private String brand;


    /**
     * 物料ID
     */
    private Long itemId;
    private String itemCode;

    @TableField(exist = false)
    private String sapItemCode;

    private String itemName;
    private String outboundNo;

    /**
     * 甚于寿命
     */
    private Long lifeTime;

    /**
     * 存在仓库
     */
    private String location;

    /**
     * 型号
     */
    @Excel(name = "型号")
    private String specification;

    private String spec;

    public String getSpec() {
        return specification;
    }

    /**
     * 工装夹具类型ID
     */
    @Excel(name = "工装夹具类型ID")
    private Long toolTypeId;

    /**
     * 工装夹具类型编码
     */
    @Excel(name = "工装夹具类型编码")
    private String toolTypeCode;

    /**
     * 工装夹具类型名称
     */
    @Excel(name = "工装夹具类型名称")
    private String toolTypeName;

    /**
     * 是否单独编码管理
     */
    @Excel(name = "是否单独编码管理")
    private String codeFlag;

    /**
     * 数量
     */
    @Excel(name = "数量")
    private Long quantity;

    /**
     * 可用数量
     */
    @Excel(name = "可用数量")
    private Long quantityAvail;

    /**
     * 保养维护类型
     */
    @Excel(name = "保养维护类型")
    private String maintenType;

    /**
     * 下一次保养周期
     */
    @Excel(name = "下一次保养周期")
    private Long nextMaintenPeriod;

    /**
     * 下一次保养日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下一次保养日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date nextMaintenDate;

    /**
     * 状态
     */
    @Excel(name = "状态")
    private String status;

    /**
     * 预留字段1
     */
    private String attr1;

    /**
     * 预留字段2
     */
    private String attr2;

    /**
     * 预留字段3
     */
    private Long attr3;

    /**
     * 预留字段4
     */
    private Long attr4;

}
