package com.ximai.mes.restful;

import com.alibaba.fastjson.JSON;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.framework.security.BasicAuth;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionVo;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;


/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/21
 */
@RestController
@RequestMapping(value = "/api/v1/productionSolution")
public class ProductionSolutionController {
    @Autowired
    private IProProductionSolutionService proProductionSolutionService;

    @ApiOperation(value = "生产版本创建")
    @BasicAuth
    @RequestMapping(value = "/productionSolutionCreate", method = RequestMethod.POST)
    public AjaxResult workOrderCreate(@RequestBody String proWorkOrderToMap) {
        try{
            ProProductionSolutionVo proProductionSolutionVo = JSON.parseObject(proWorkOrderToMap).toJavaObject(ProProductionSolutionVo.class);
            int i = proProductionSolutionService.productionSolutionCreate(proProductionSolutionVo);
            if (i == 9)
                return AjaxResult.error("传入数据为空");
            if (i == 2)
                return AjaxResult.error("保存失败");
            if (i == 3)
                return AjaxResult.error("数据不存在");
            if (i == 4)
                return AjaxResult.error("删除失败");
        }catch (Exception e){
            return AjaxResult.error(e.getMessage());
        }

        return AjaxResult.success();
    }

}
