package com.ximai.mes.qc.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.qc.domain.QcTemplateProcess;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 检测模板-工序Mapper接口
 *
 * @author generator
 * @date 2024-02-18
 */
public interface QcTemplateProcessMapper extends BaseMapper<QcTemplateProcess> {
    /**
     * 查询检测模板-工序
     *
     * @param id 检测模板-工序主键
     * @return 检测模板-工序
     */
    QcTemplateProcess selectQcTemplateProcessById(Long id);

    /**
     * 查询检测模板-工序列表
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 检测模板-工序集合
     */
    List<QcTemplateProcess> selectQcTemplateProcessList(QcTemplateProcess qcTemplateProcess);

    /**
     * 新增检测模板-工序
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 结果
     */
    int insertQcTemplateProcess(QcTemplateProcess qcTemplateProcess);

    /**
     * 修改检测模板-工序
     *
     * @param qcTemplateProcess 检测模板-工序
     * @return 结果
     */
    int updateQcTemplateProcess(QcTemplateProcess qcTemplateProcess);

    /**
     * 删除检测模板-工序
     *
     * @param id 检测模板-工序主键
     * @return 结果
     */
    int deleteQcTemplateProcessById(Long id);

    /**
     * 批量删除检测模板-工序
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcTemplateProcessByIds(Long[] ids);

    /**
     * 查询检测模板-工序列表
     *
     * @param query 检测模板-工序
     * @return 检测模板-工序集合
     */
    @Select(value = "select t1.* from qc_template_process t1 \n" +
            "inner join qc_template t2 on t1.template_id = t2.id\n" +
            "${ew.customSqlSegment}")
    List<QcTemplateProcess> selectListJoinTemplateByQw(@Param("ew") QueryWrapper<QcTemplateProcess> query);


}
