package com.ximai.mes.pro.schedule.strategy;

import cn.hutool.core.util.NumberUtil;
import com.ximai.mes.pro.schedule.IOperationTimeCalculator;
import com.ximai.mes.pro.schedule.TaskSchedulingContext;

import java.util.List;

/**
 * 产能评估设备
 *   足够=10、单台不足=5、无产能=0
 *   跨时间段数量:
 *      - NumberUtil.min(N,5)+1
 *
 */
public class EvaluateEquipmentCapacity implements EvaluateEquipment{
    @Override
    public double evaluate(TaskSchedulingContext context, IOperationTimeCalculator.OperationTimePlan operationTimePlan
            , List<TaskSchedulingContext.TaskSchedulingResultContext> scheduleResult) {
        int rst = 0;
        List<IOperationTimeCalculator.OperationTimePlanItem> operationTimePlanItemList = operationTimePlan.getPlan();
        if(operationTimePlanItemList.isEmpty()){
            return rst;
        }
        if(operationTimePlan.getScheduledSuccess()){
            rst = 10;
        }else {
            rst = 5;
        }
        rst = rst - NumberUtil.min(operationTimePlanItemList.size(),5)+1;
        return rst;
    }

    @Override
    public int weight() {
        return 5;
    }

}
