package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 工作单元对象 md_workunit
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Data
@ApiModel("工作单元")
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkunitExcelExport extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 工作站ID
     */
    @ExcelProperty("工作站ID")
    private Long workstationId;

    /**
     * 工作站名称
     */
    @ExcelProperty("工作站名称")
    private String workstationName;

    /**
     * 工作站编码
     */
    @ExcelProperty("工作站编码")
    private String workstationCode;

    /**
     * 工作单元编码
     */
    @ExcelProperty("工作单元编码")
    private String workunitCode;

    /**
     * 工作单元名称
     */
    @ExcelProperty("工作单元名称")
    private String workunitName;

    /**
     * 是否故障
     */
    @ExcelProperty("是否故障")
    private String faultFlag;

    /**
     * 是否启用
     */
    @ExcelProperty("是否启用")
    private String enableFlag;

    /** 固化时间 */
    @ExcelProperty("固化时间")
    private BigDecimal solidifyTime;

}
