package com.ximai.mes.wm.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.wm.domain.WmIssueHeader;
import com.ximai.mes.wm.domain.tx.IssueTxBean;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 生产领料单头Mapper接口
 *
 * @date 2022-07-14
 */
public interface WmIssueHeaderMapper {
    /**
     * 查询生产领料单头
     *
     * @param issueId 生产领料单头主键
     * @return 生产领料单头
     */
    WmIssueHeader selectWmIssueHeaderByIssueId(Long issueId);

    /**
     * 查询生产领料单头列表
     *
     * @param wmIssueHeader 生产领料单头
     * @return 生产领料单头集合
     */
    List<WmIssueHeader> selectWmIssueHeaderList(WmIssueHeader wmIssueHeader);

    /**
     * 检查生产领料单编号是否唯一
     *
     * @param wmIssueHeader
     * @return
     */
    WmIssueHeader checkIssueCodeUnique(WmIssueHeader wmIssueHeader);

    /**
     * 新增生产领料单头
     *
     * @param wmIssueHeader 生产领料单头
     * @return 结果
     */
    int insertWmIssueHeader(WmIssueHeader wmIssueHeader);

    /**
     * 修改生产领料单头
     *
     * @param wmIssueHeader 生产领料单头
     * @return 结果
     */
    int updateWmIssueHeader(WmIssueHeader wmIssueHeader);

    /**
     * 删除生产领料单头
     *
     * @param issueId 生产领料单头主键
     * @return 结果
     */
    int deleteWmIssueHeaderByIssueId(Long issueId);

    int deleteWmIssueHeaderByIssueCode(String issueCode);

    /**
     * 批量删除生产领料单头
     *
     * @param issueIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteWmIssueHeaderByIssueIds(Long[] issueIds);


    List<IssueTxBean> getTxBeans(Long issueId);

    @Select("select wih.*,\n" +
            "               mw.workstation_code,\n" +
            "               mw.workstation_name,\n" +
            "               pt.task_code\n" +
            "        from wm_issue_header wih\n" +
            "                 left join pro_task pt\n" +
            "                           on wih.task_id = pt.task_id\n" +
            "                 left join md_workstation mw\n" +
            "                           on wih.workstation_id = mw.workstation_id\n" +
            "                            ${ew.customSqlSegment} ")
    List<WmIssueHeader> selectListByQw(@Param("ew") QueryWrapper<WmIssueHeader> query);

    ;


    @Select("select * from wm_issue_header where issue_code=#{issueCode}")
    WmIssueHeader selectWmIssueHeaderCodes(@Param("issueCode") String issueCode);
}
