package com.ximai.mes.report.request;

import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
public class WorkOrderProgressRequest {
    /**
     * 项目号（工单项目号）
     * 订单号（工单订单号）
     * 生产工单（生产工单号）
     * 产品编码（产品编码）
     * 产品名称（点击放大镜单选产品信息，也可直接输入名称执行搜索）
     */

    @ApiModelProperty("客户项目号")
    private String customerProjectNo;


    @ApiModelProperty("订单单号")
    private String orderCode;

    @ApiModelProperty( "工单编码")
    private String workorderCode;

    /**
     * 产品ID
     */
    @ApiModelProperty(   "产品ID")
    private Long productId;
    /**
     * 产品编号
     */
    @Excel(name = "产品编号")
    @ApiModelProperty(   "产品编号")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(   "产品名称")
    private String productName;
}
