package com.ximai.mes.pro.service.task;

import java.util.List;

import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.task.ProFdQrcodePrintRecord;

/**
 * 报工打印二维码记录表Service接口
 * 
 * @author generator
 * @date 2024-03-19
 */
public interface IProFdQrcodePrintRecordService 
{
    /**
     * 查询报工打印二维码记录表
     * 
     * @param recordId 报工打印二维码记录表主键
     * @return 报工打印二维码记录表
     */
    public ProFdQrcodePrintRecord selectProFdQrcodePrintRecordByRecordId(Long recordId);

    /**
     * 查询报工打印二维码记录表列表
     * 
     * @param proFdQrcodePrintRecord 报工打印二维码记录表
     * @return 报工打印二维码记录表集合
     */
    public List<ProFdQrcodePrintRecord> selectProFdQrcodePrintRecordList(ProFdQrcodePrintRecord proFdQrcodePrintRecord);

    /**
     * 新增报工打印二维码记录表
     * 
     * @param proFdQrcodePrintRecord 报工打印二维码记录表
     * @return 结果
     */
    public int insertProFdQrcodePrintRecord(ProFdQrcodePrintRecord proFdQrcodePrintRecord);

    /**
     * 修改报工打印二维码记录表
     * 
     * @param proFdQrcodePrintRecord 报工打印二维码记录表
     * @return 结果
     */
    public int updateProFdQrcodePrintRecord(ProFdQrcodePrintRecord proFdQrcodePrintRecord);

    /**
     * 批量删除报工打印二维码记录表
     * 
     * @param recordIds 需要删除的报工打印二维码记录表主键集合
     * @return 结果
     */
    public int deleteProFdQrcodePrintRecordByRecordIds(Long[] recordIds);

    /**
     * 删除报工打印二维码记录表信息
     * 
     * @param recordId 报工打印二维码记录表主键
     * @return 结果
     */
    public int deleteProFdQrcodePrintRecordByRecordId(Long recordId);

    void insertProFdQrcodePrintRecordfeedback(ProFeedback feedback);
}
