package com.ximai.mes.pro.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * BOM组件对象 pro_bom_item
 *
 * @author zht
 * @date 2024-01-16
 */
public class ProBomItem extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long bomItemId;

    /**
     *  物料名称
     */
    @Excel(name = "itemName")
    private String itemName;

    /** BOMID */
    @Excel(name = "BOMID")
    private Long bomId;

    /** 物料ID */
    @Excel(name = "物料ID")
    private Long itemId;

    /** 组件数量 */
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /** 计量单位 */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /** 报废百分比 */
    @Excel(name = "报废百分比")
    private BigDecimal scrapPercentage;

    /** 替代组 */
    @Excel(name = "替代组")
    private String alternativeGroup;

    /** 替代优先级 */
    @Excel(name = "替代优先级")
    private Long alternativePriorities;

    /** 替代策略 */
    @Excel(name = "替代策略")
    private String alternativeStrategy;

    /** 替代使用概率 */
    @Excel(name = "替代使用概率")
    private BigDecimal alternativeProbability;

    /** BOM行备注 */
    @Excel(name = "BOM行备注")
    private String bomItemRemark;

    /** 物料备注 */
    @Excel(name = "物料备注")
    private String itemRemark;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;

    public void setBomItemId(Long bomItemId)
    {
        this.bomItemId = bomItemId;
    }

    public Long getBomItemId()
    {
        return bomItemId;
    }
    public void setBomId(Long bomId)
    {
        this.bomId = bomId;
    }

    public Long getBomId()
    {
        return bomId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setQuantity(BigDecimal quantity)
    {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity()
    {
        return quantity;
    }
    public void setUnitOfMeasure(String unitOfMeasure)
    {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure()
    {
        return unitOfMeasure;
    }
    public void setScrapPercentage(BigDecimal scrapPercentage)
    {
        this.scrapPercentage = scrapPercentage;
    }

    public BigDecimal getScrapPercentage()
    {
        return scrapPercentage;
    }
    public void setAlternativeGroup(String alternativeGroup)
    {
        this.alternativeGroup = alternativeGroup;
    }

    public String getAlternativeGroup()
    {
        return alternativeGroup;
    }
    public void setAlternativePriorities(Long alternativePriorities)
    {
        this.alternativePriorities = alternativePriorities;
    }

    public Long getAlternativePriorities()
    {
        return alternativePriorities;
    }
    public void setAlternativeStrategy(String alternativeStrategy)
    {
        this.alternativeStrategy = alternativeStrategy;
    }

    public String getAlternativeStrategy()
    {
        return alternativeStrategy;
    }
    public void setAlternativeProbability(BigDecimal alternativeProbability)
    {
        this.alternativeProbability = alternativeProbability;
    }

    public BigDecimal getAlternativeProbability()
    {
        return alternativeProbability;
    }
    public void setBomItemRemark(String bomItemRemark)
    {
        this.bomItemRemark = bomItemRemark;
    }

    public String getBomItemRemark()
    {
        return bomItemRemark;
    }
    public void setItemRemark(String itemRemark)
    {
        this.itemRemark = itemRemark;
    }

    public String getItemRemark()
    {
        return itemRemark;
    }
    public void setEnableFlag(String enableFlag)
    {
        this.enableFlag = enableFlag;
    }

    public String getEnableFlag()
    {
        return enableFlag;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("bomItemId", getBomItemId())
            .append("bomId", getBomId())
            .append("itemId", getItemId())
            .append("quantity", getQuantity())
            .append("unitOfMeasure", getUnitOfMeasure())
            .append("scrapPercentage", getScrapPercentage())
            .append("alternativeGroup", getAlternativeGroup())
            .append("alternativePriorities", getAlternativePriorities())
            .append("alternativeStrategy", getAlternativeStrategy())
            .append("alternativeProbability", getAlternativeProbability())
            .append("bomItemRemark", getBomItemRemark())
            .append("itemRemark", getItemRemark())
            .append("enableFlag", getEnableFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
