package com.ximai.mes.od.mapper;

import com.ximai.mes.od.domain.OdPurchaseOrder;

import java.util.List;

/**
 * 客户采购订单Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface OdPurchaseOrderMapper {
    /**
     * 查询客户采购订单
     *
     * @param id 客户采购订单主键
     * @return 客户采购订单
     */
    OdPurchaseOrder selectOdPurchaseOrderById(Long id);

    OdPurchaseOrder getByNo(String purchaseNo);

    /**
     * 查询客户采购订单列表
     *
     * @param odPurchaseOrder 客户采购订单
     * @return 客户采购订单集合
     */
    List<OdPurchaseOrder> selectOdPurchaseOrderList(OdPurchaseOrder odPurchaseOrder);

    /**
     * 新增客户采购订单
     *
     * @param odPurchaseOrder 客户采购订单
     * @return 结果
     */
    int insertOdPurchaseOrder(OdPurchaseOrder odPurchaseOrder);


    /**
     * 修改客户采购订单
     *
     * @param odPurchaseOrder 客户采购订单
     * @return 结果
     */
    int updateOdPurchaseOrder(OdPurchaseOrder odPurchaseOrder);

    /**
     * 删除客户采购订单
     *
     * @param id 客户采购订单主键
     * @return 结果
     */
    int deleteOdPurchaseOrderById(String id);

    /**
     * 批量删除客户采购订单
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    int deleteOdPurchaseOrderByIds(String[] ids);
}
