package com.ximai.mes.md.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import lombok.Data;

import java.util.Date;

/**
 * 车辆列表对象 md_vehicle
 *
 * @author generator
 * @date 2024-01-25
 */
@Data
public class MdVehicleExcel
{
    private static final long serialVersionUID = 1L;

    /** 车辆名称 */
    @Excel(name = "车辆名称")
    private String vehicleName;

    /** 车牌号 */
    @Excel(name = "车牌号")
    private String licensePlate;

    /** 车型 */
    @Excel(name = "车型")
    private String vehicleModel;

    /** 座位数 */
    @Excel(name = "座位数")
    private Integer seating;

    /** 购买时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "购买时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date purchaseDate;

    /** 验车时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "验车时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date inspectionDate;

}
