package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdSaleOrderGroup;

/**
 * 销售订单销售小组Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface MdSaleOrderGroupMapper
{
    /**
     * 查询销售订单销售小组
     *
     * @param id 销售订单销售小组主键
     * @return 销售订单销售小组
     */
    public MdSaleOrderGroup selectMdSaleOrderGroupById(Long id);

    /**
     * 查询销售订单销售小组列表
     *
     * @param mdSaleOrderGroup 销售订单销售小组
     * @return 销售订单销售小组集合
     */
    public List<MdSaleOrderGroup> selectMdSaleOrderGroupList(MdSaleOrderGroup mdSaleOrderGroup);

    /**
     * 新增销售订单销售小组
     *
     * @param mdSaleOrderGroup 销售订单销售小组
     * @return 结果
     */
    public int insertMdSaleOrderGroup(MdSaleOrderGroup mdSaleOrderGroup);

    /**
     * 修改销售订单销售小组
     *
     * @param mdSaleOrderGroup 销售订单销售小组
     * @return 结果
     */
    public int updateMdSaleOrderGroup(MdSaleOrderGroup mdSaleOrderGroup);

    /**
     * 删除销售订单销售小组
     *
     * @param id 销售订单销售小组主键
     * @return 结果
     */
    public int deleteMdSaleOrderGroupById(Long id);

    /**
     * 批量删除销售订单销售小组
     *
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdSaleOrderGroupByIds(Long[] ids);
}
